package com.ejie.aa17a.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa17a.dao.iface.Aa17aLimiteContaminanteDao;
import com.ejie.aa17a.model.Aa17aLimiteContaminante;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aLimiteContaminanteDaoImpl generated by UDA, 19-dic-2013 17:46:35.
 * 
 * @author UDA
 */

@Transactional
public class Aa17aLimiteContaminanteDaoImpl implements
		Aa17aLimiteContaminanteDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Aa17aLimiteContaminante> rwMap = new RowMapper<Aa17aLimiteContaminante>() {
		public Aa17aLimiteContaminante mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa17aLimiteContaminante limiteContaminante = new Aa17aLimiteContaminante();
			Locale locale = LocaleContextHolder.getLocale();
			limiteContaminante.setIdLimite(resultSet.getLong("IDLIMITE"));
			limiteContaminante.setIdContaminante(resultSet.getLong("IDCONTAMINANTE"));
			limiteContaminante.setIdTipoLimite(resultSet.getLong("IDTIPOLIMITE"));
			limiteContaminante.setValorLimite(resultSet.getBigDecimal("VALORLIMITE"));

			if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
				limiteContaminante.setDescripcion(resultSet.getString("DESCRIPCIONEU"));
			}
			else {
				limiteContaminante.setDescripcion(resultSet.getString("DESCRIPCIONES"));
			}

			if (resultSet.getTimestamp("FECHABAJA") != null) {
				limiteContaminante.setFechaBaja(new Date(resultSet.getTimestamp("FECHABAJA").getTime()));
			}

			if (limiteContaminante.getFechaBaja() != null) {
				limiteContaminante.setEstado(Aa17aConstantes.ESTADO_INACTIVO);
			}
			else {
				limiteContaminante.setEstado(Aa17aConstantes.ESTADO_ACTIVO);
			}

			limiteContaminante.setColorLimite(resultSet.getString("COLOR"));

			return limiteContaminante;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */

	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a List of rows in the Aa17aLimiteContaminante table.
	 * 
	 * @param aa17alimitecontaminante
	 *            Aa17aLimiteContaminante
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Aa17aLimiteContaminante> findAll(
			Aa17aLimiteContaminante aa17alimitecontaminante) {
		StringBuilder query = new StringBuilder();
		query.append(" SELECT AA1709S00.T09_LIMITE_ID IDLIMITE, ");
		query.append(" AA1709S00.T02_CONTAMINANTE_ID IDCONTAMINANTE, AA1700S00.T00_REG_ID IDTIPOLIMITE, ");
		query.append(" AA1700S00.T00_DESC_ES DESCRIPCIONES, AA1700S00.T00_DESC_EU DESCRIPCIONEU, ");
		query.append(" AA1709S00.T09_VALOR_LIMITE VALORLIMITE, AA1709S00.T09_FECHA_BAJA FECHABAJA, AA1709S00.T09_COLOR COLOR ");
		query.append(" FROM AA1700S00 ");
		query.append(" INNER JOIN AA1709S00 ON AA1700S00.T00_REG_ID = AA1709S00.T00_TIPO_LIMITE_ID ");
		query.append(" AND AA1709S00.T02_CONTAMINANTE_ID=? AND AA1700S00.T00_TABLA_ID=? ");
		//si necesito los limites para la pantalla de datos historicos
		if (aa17alimitecontaminante.getTipoLimite().equals(Aa17aConstantes.TIPO_LIMITE_DIARIO)) {
			query.append(" AND T00_REG_ID IN (?,?) ");
		}
		else {//si son para la pantalla de datos horarios
			query.append(" AND T00_REG_ID = ? ");
		}
		query.append(" WHERE AA1709S00.T09_FECHA_BAJA IS NULL ");

		//si necesito los limites para la pantalla de datos historicos
		if (aa17alimitecontaminante.getTipoLimite().equals(Aa17aConstantes.TIPO_LIMITE_DIARIO)) {
			return (List<Aa17aLimiteContaminante>) this.jdbcTemplate.query(
					query.toString(), this.rwMap, aa17alimitecontaminante.getIdContaminante(), Aa17aConstantes.TABLA_TIPO_LIMITE, Aa17aConstantes.LIMITE_ANUAL_ID, Aa17aConstantes.LIMITE_DIARIO_ID);

		}
		else {//si son para la pantalla de datos horarios
			return (List<Aa17aLimiteContaminante>) this.jdbcTemplate.query(
					query.toString(), this.rwMap, aa17alimitecontaminante.getIdContaminante(), Aa17aConstantes.TABLA_TIPO_LIMITE, Aa17aConstantes.LIMITE_HORARIO_ID);
		}

	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
